#pragma compile(Icon, "AutoIt_Main_v10_48x48_only_RGB-A.ico")
#AutoIt3Wrapper_Run_Au3Stripper=y
#Au3Stripper_Parameters=/so /pe /rm
#AutoIt3Wrapper_Run_After=del /f /q "%scriptdir%\%scriptfile%_stripped.au3"

;coded by UEZ build 2014-03-17 - idea taken from http://codepen.io/tvolodimir/pen/oLijd
#include <GDIPlus.au3>
#include <GUIConstantsEx.au3>
#include <WindowsConstants.au3>

AutoItSetOption("GUIOnEventMode", 1)
_GDIPlus_Startup()

Global Const $iW = 600, $iH = $iW
Global Const $hGUI = GUICreate("GDI+ Spiral Rotating Circles", $iW, $iH)
GUISetState()

Global Const $hDC = _WinAPI_GetDC($hGUI)
Global Const $hHBitmap = _WinAPI_CreateCompatibleBitmap($hDC, $iW, $iH)
Global Const $hDC_backbuffer = _WinAPI_CreateCompatibleDC($hDC)
Global Const $DC_obj = _WinAPI_SelectObject($hDC_backbuffer, $hHBitmap)
Global Const $hContext = _GDIPlus_GraphicsCreateFromHDC($hDC_backbuffer)
_GDIPlus_GraphicsSetSmoothingMode($hContext, 4 + (@OSBuild > 5999) * 1)
_GDIPlus_GraphicsSetPixelOffsetMode($hContext, $GDIP_PIXELOFFSETMODE_HIGHQUALITY)
_GDIPlus_GraphicsSetCompositingQuality($hContext, 2)

Global Const $iCircles = 8, $iDiameter = $iW, $fRadius = $iDiameter / 2, $iW2 = $iW / 2, $iH2 = $iH / 2, $fQ = 0.66666667, $fRad = 3.14159265358979 / 180, _
			 $hPen = _GDIPlus_PenCreate(0xC0808080), $hBrush = _GDIPlus_BrushCreateSolid()
Global $i, $iSize = 1, $aCircles[$iCircles][6]
Global $aColors[$iCircles][8] = [ _
								[0xFF47FFC1, 0xFF6BFFCD, 0xFF88FFD7, 0xFFA0FFDF, 0xFFB3FFE6, 0xFFA0FFDF, 0xFF88FFD7, 0xFF6BFFCD], _
								[0xFFC1FF47, 0xFFCDFF6B, 0xFFD7FF88, 0xFFDFFFA0, 0xFFE6FFB3, 0xFFDFFFA0, 0xFFD7FF88, 0xFFCDFF6B], _
								[0xFFFFC147, 0xFFFFCD6B, 0xFFFFD788, 0xFFFFDFA0, 0xFFFFE6B3, 0xFFFFDFA0, 0xFFFFD788, 0xFFFFCD6B], _
								[0xFFFF47C1, 0xFFFF6BCD, 0xFFFF88D7, 0xFFFFA0DF, 0xFFFFB3E6, 0xFFFFA0DF, 0xFFFF88D7, 0xFFFF6BCD], _
								[0xFF47C1FF, 0xFF6BCDFF, 0xFF88D7FF, 0xFFA0DFFF, 0xFFB3E6FF, 0xFFA0DFFF, 0xFF88D7FF, 0xFF6BCDFF], _
								[0xFFFAFF38, 0xFFF9FF5B, 0xFFFBFF7E, 0xFFFDFF9B, 0xFFFEFFB0, 0xFFFDFF9B, 0xFFFBFF7E, 0xFFF9FF5B], _
								[0xFFC147FF, 0xFFCD6BFF, 0xFFD788FF, 0xFFDFA0FF, 0xFFE6B3FF, 0xFFDFA0FF, 0xFFD788FF, 0xFFCD6BFF], _
								[0xFF803F37, 0xFF80485E, 0xFF805C80, 0xFF806D9B, 0xFF807BAF, 0xFF806D9B, 0xFF805C80, 0xFF80485E]]

$aCircles[0][0] = $iDiameter * $iSize
For $i = 0 To UBound($aCircles) - 1
	$aCircles[$i][0] = 0 ;x position
	$aCircles[$i][1] = 0 ;y position
	$aCircles[$i][2] = $iW * $fQ^$i ;diameter
	$aCircles[$i][3] = $aCircles[$i][2] / 2 ;radius
	$aCircles[$i][4] = -0x8080D2 ;angle
	$aCircles[$i][5] = 0xFF000000 ;color
Next

_WinAPI_BitBlt($hDC, 0, 0, $iW, $iH, $hDC_backbuffer, 0, 0, $SRCCOPY)

GUISetOnEvent($GUI_EVENT_CLOSE , "_Exit")

Do
	_GDIPlus_GraphicsClear($hContext, 0xFF808090)
	_GDIPlus_BrushSetSolidColor($hBrush, $aCircles[0][5])

	For $i = 0 To UBound($aColors) - 1
		_GDIPlus_BrushSetSolidColor($hBrush, $aColors[0][$i])
		DllCall($__g_hGDIPDll, "int", "GdipFillPie", "handle", $hContext, "handle", $hBrush, "float", $aCircles[0][0], "float", $aCircles[0][1], _
			"float", $aCircles[0][2], "float", $aCircles[0][2], "float", $i * 45, "float", 45)
	Next
	DllCall($__g_hGDIPDll, "int", "GdipDrawEllipse", "handle", $hContext, "handle", $hPen, "float", $aCircles[0][0], "float", $aCircles[0][1], _
			"float", $aCircles[0][2], "float", $aCircles[0][2])
	For $i = 1 To UBound($aCircles) - 1
		$aCircles[$i][0] = -$aCircles[$i][3] + $aCircles[$i - 1][0] + $aCircles[$i - 1][3] + Cos($aCircles[$i][4] * $fRad) * ($aCircles[$i - 1][3] - $aCircles[$i][3])
		$aCircles[$i][1] = -$aCircles[$i][3] + $aCircles[$i - 1][1] + $aCircles[$i - 1][3] + Sin($aCircles[$i][4] * $fRad) * ($aCircles[$i - 1][3] - $aCircles[$i][3])
		_GDIPlus_BrushSetSolidColor($hBrush, $aCircles[$i][5])
		DllCall($__g_hGDIPDll, "int", "GdipFillEllipse", "handle", $hContext, "handle", $hBrush, "float", $aCircles[$i][0], "float", $aCircles[$i][1], _
			"float", $aCircles[$i][2], "float", $aCircles[$i][2])
		For $j = 0 To UBound($aColors) - 1
			_GDIPlus_BrushSetSolidColor($hBrush, $aColors[$i][$j])
			DllCall($__g_hGDIPDll, "int", "GdipFillPie", "handle", $hContext, "handle", $hBrush, "float", $aCircles[$i][0], "float", $aCircles[$i][1], _
			"float", $aCircles[$i][2], "float", $aCircles[$i][2], "float", 1.3333333 * $aCircles[$i][4] + $j * 45, "float", 45)
		Next
		DllCall($__g_hGDIPDll, "int", "GdipDrawEllipse", "handle", $hContext, "handle", $hPen, "float", $aCircles[$i][0], "float", $aCircles[$i][1], _
			"float", $aCircles[$i][2], "float", $aCircles[$i][2])
		$aCircles[$i][4] += 1.3333333 + $i * 1.66666667 ;rotation speed (angle)
	Next
	_WinAPI_BitBlt($hDC, 0, 0, $iW, $iH, $hDC_backbuffer, 0, 0, $SRCCOPY)
Until False * Sleep(10)

Func _Exit()
	_GDIPlus_BrushDispose($hBrush)
	_GDIPlus_PenDispose($hPen)
	_GDIPlus_GraphicsDispose($hContext)
	_WinAPI_SelectObject($hDC, $DC_obj)
	_WinAPI_DeleteObject($hHBitmap)
	_WinAPI_ReleaseDC($hGUI, $hDC)
	_GDIPlus_Shutdown()
	GUIDelete()
	Exit
EndFunc